<?php

use Illuminate\Database\Seeder;
use App\Models\Tenant\Product;
use App\Models\Tenant\User;

class TenantSeeder extends Seeder
{
    /**
     * Run the database seeds.
     *
     * @return void
     */
    public function run() {

//        factory(User::class)->create();

        // tables independents
        $this->call(ConfigTypeTransaction::class);
        $this->call(ConfigTypeMovementMoney::class);
        $this->call(ConfigPaymentMethod::class);
        $this->call(ConfigTaxesSeeder::class);
        $this->call(ConfigCurrencySeeder::class);
        $this->call(ConfigTypeDocument::class);
        $this->call(ConfigTypeVoucher::class);
        $this->call(ConfigBillingCode::class);
        $this->call(UserProfileSeeder::class);
        $this->call(CatalogTypePrice::class);
        $this->call(ConfigUnitMeasure::class);
        $this->call(CompanyBranchOffice::class);
        $this->call(BranchConfigSeeder::class);
        $this->call(WarehouseConceptSeeder::class);
        $this->call(AccountTypeSeeder::class);
        $this->call(RoomTypeSeeder::class);
        $this->call(RateSeeder::class);
        $this->call(ConfigTransferReason::class);
        $this->call(ConfigModeTransport::class);

        if(config('app.dev_mode') == true){

            $this->call(BranchOfficeSeeder::class);
            $this->call(BranchBoxSeeder::class);

            $this->call(DevUbigeoDepartamentSeeder::class);
            $this->call(DevUbigeoProvinceSeeder::class);
            $this->call(DevUbigeoDistrictSeeder::class);

            $this->call(DevUserTenantSeeder::class);
            $this->call(DevWarehouseSeeder::class);

            $this->call(ConfigSerieVoucher::class);
            // hotel development

            $this->call(DevBedroomSeeder::class);
            $this->call(DevRatesBedroomSeeder::class);
        }
        else{
            $this->call(BranchOfficeSeeder::class);
            $this->call(BranchBoxSeeder::class);

            $this->call(UbigeoDepartamentSeeder::class);
            $this->call(UbigeoProvinceSeeder::class);
            $this->call(UbigeoDistrictSeeder::class);

            $this->call(UserTenantTableSeeder::class);
            $this->call(Warehouse::class);

            $this->call(ConfigSerieVoucher::class);

        }

        // tables dependientes
//        $this->call(UserTenantTableSeeder::class);
        $this->call(ClientTableSeeder::class);
        $this->call(UbigeoDetailTableSeeder::class);
        $this->call(MoneyConceptSeeder::class);

        // encuestas
        $this->call(InquirySurveySeeder::class);

    }
}
