/**
 * Created by JAIR on 9/12/2016.
 */

$(function () {

    // $('#rooms, #room_adults, #room_infant').select2({
    //     minimumResultsForSearch: -1
    // });
    var room_adults = $('#room_adults');
    var room_infant = $('#room_infant');
    var number_days = $('#number_days');
    var rooms = $('#rooms');

    var dpd1 = $('#dpd1');
    var dpd2 = $('#dpd2');
    var nowTemp = new Date();
    var now = new Date(nowTemp.getFullYear(), nowTemp.getMonth(), nowTemp.getDate(), 0, 0, 0, 0);

    var checkin = dpd1.datepicker({
        language: 'es',
        format: 'dd-mm-yyyy',
        todayHighlight: true,
        weekStart: 0,
        beforeShowDay: function (date) {
            return date.valueOf() < now.valueOf() ? 'disabled' : '';
        }
    }).on('changeDate', function (ev) {
        if (ev.date.valueOf() > checkout.viewDate.valueOf()) {
            var newDate = new Date(ev.date);
            newDate.setDate(newDate.getDate() + 1);
            checkout.setDate(newDate);
        }
        else {
            checkout.setDate(ev.date + 1);
        }
        checkin.hide();
        dpd2[0].focus();
        calculateDays();
    }).data('datepicker');

    var checkout = dpd2.datepicker({
        language: 'es',
        format: 'dd-mm-yyyy',
        todayHighlight: true,
        weekStart: 0,
        beforeShowDay: function (date) {
            var date1 = new Date(date);
            var date2 = new Date(checkin.viewDate);
            date1 = moment(date1);
            date2 = moment(date2);
            var diffDays = date2.diff(date1, 'days');
            return (diffDays >= 0) ? 'disabled' : '';
            // return date.valueOf() <= checkin.viewDate.valueOf() ? 'disabled' : '';
        }
    }).on('changeDate', function (ev) {
        checkout.hide();
        calculateDays();
    }).data('datepicker');

    $.fn.required = function () {
        if ($(this).val() == '' || $(this).val() == null) {
            $(this).focus();
            return false;
        } else {
            return true;
        }
    };

    $('#frm_reservation').submit(function (e) {
        var bval = true;
        bval = bval && dpd1.required();
        bval = bval && dpd2.required();
        bval = bval && room_adults.required();
        bval = bval && room_infant.required();
        bval = bval && rooms.required();

        if (number_days.val() == '' || number_days.val() <= 0) {
            dpd2.focus();
            return false;
        }
        if (bval) {
            return true;
        }
        e.preventDefault();
    });

    dpd1.prop('disabled', false);
    dpd2.prop('disabled', false);

    // changeRoom();
});

function calculateDays() {
    var number_days = $('#number_days');
    var dpd1 = $('#dpd1').val();
    var dpd2 = $('#dpd2').val();
    if (dpd1 != '' && dpd2 != '') {
        // console.log(dpd1);
        // console.log(dpd2);
        var date1 = moment(dpd1, 'DD-MM-YYYY');
        var date2 = moment(dpd2, 'DD-MM-YYYY');
        var diffDays = date2.diff(date1, 'days');
        number_days.val(diffDays);
        var fc = $('.form-control, .btn');
        var room = $('#rooms');
        var room_adults = $('#room_adults');
        var room_infant = $('#room_infant');
        // fc.prop('disabled', true);
        var data = {
            start: dpd1,
            end: dpd2,
            adults: 0,
            infants: 0
        };
        var i;
        $.get('/getDaysAndRooms/', data).done(function (response) {
            room_adults.html('');
            room_infant.html('');
            room.html('');
            // fc.prop('disabled', false);
            // console.log(response);
            var adults = response.adults;
            if (adults > 0) {
                for (i = 1; i <= adults; i++) {
                    room_adults.append('<option value="' + i + '">' + i + '</option>');
                }
            }
            var infants = response.infants;
            for (i = 0; i <= infants; i++) {
                room_infant.append('<option value="' + i + '">' + i + '</option>');
            }
            var rooms = response.rooms;
            if (rooms.length > 0) {
                for (i = 0; i < rooms.length; i++) {
                    room.append('<option value="' + rooms[i].pk + '">' + rooms[i].description + '</option>');
                }
            }
        }).fail(function (e) {
            // fc.prop('disabled', false);
        });
    } else {
        number_days.val('');
    }

}

function changeRoom() {
    var room = $('#rooms');
    var fc = $('.form-control, .btn');
    var room_adults = $('#room_adults');
    var room_infant = $('#room_infant');
    var dpd1 = $('#dpd1').val();
    var dpd2 = $('#dpd2').val();
    // fc.prop('disabled', true);
    room.html('');
    var data = {
        start: dpd1,
        end: dpd2,
        adults: room_adults.val(),
        infants: room_infant.val()
    };
    $.get('/getDaysAndRooms/', data).done(function (response) {
        // fc.prop('disabled', false);
        var rooms = response.rooms;
        if (rooms.length > 0) {
            for (var i = 0; i < rooms.length; i++) {
                room.append('<option value="' + rooms[i].pk + '">' + rooms[i].description + '</option>');
            }
        }
    }).fail(function (e) {
        // fc.prop('disabled', false);
    });
}

//region EFECTO SCROLL
var service = $('.service_scroll');
service.bind('click', function (e) {
    e.preventDefault();
    $('html,body').animate({scrollTop: $(this.hash).offset().top - 60});
});
//endregion
