var numeroALetras = (function () {
    function Unidades(num) {

        switch (num) {
            case 1:
                return 'UN';
            case 2:
                return 'DOS';
            case 3:
                return 'TRES';
            case 4:
                return 'CUATRO';
            case 5:
                return 'CINCO';
            case 6:
                return 'SEIS';
            case 7:
                return 'SIETE';
            case 8:
                return 'OCHO';
            case 9:
                return 'NUEVE';
        }

        return '';
    }

    function Decenas(num) {

        let decena = Math.floor(num / 10);
        let unidad = num - (decena * 10);

        switch (decena) {
            case 1:
                switch (unidad) {
                    case 0:
                        return 'DIEZ';
                    case 1:
                        return 'ONCE';
                    case 2:
                        return 'DOCE';
                    case 3:
                        return 'TRECE';
                    case 4:
                        return 'CATORCE';
                    case 5:
                        return 'QUINCE';
                    default:
                        return 'DIECI' + Unidades(unidad);
                }
            case 2:
                switch (unidad) {
                    case 0:
                        return 'VEINTE';
                    default:
                        return 'VEINTI' + Unidades(unidad);
                }
            case 3:
                return DecenasY('TREINTA', unidad);
            case 4:
                return DecenasY('CUARENTA', unidad);
            case 5:
                return DecenasY('CINCUENTA', unidad);
            case 6:
                return DecenasY('SESENTA', unidad);
            case 7:
                return DecenasY('SETENTA', unidad);
            case 8:
                return DecenasY('OCHENTA', unidad);
            case 9:
                return DecenasY('NOVENTA', unidad);
            case 0:
                return Unidades(unidad);
        }
    }

    function DecenasY(strSin, numUnidades) {
        if (numUnidades > 0)
            return strSin + ' Y ' + Unidades(numUnidades)

        return strSin;
    }

    function Centenas(num) {
        let centenas = Math.floor(num / 100);
        let decenas = num - (centenas * 100);

        switch (centenas) {
            case 1:
                if (decenas > 0)
                    return 'CIENTO ' + Decenas(decenas);
                return 'CIEN';
            case 2:
                return 'DOSCIENTOS ' + Decenas(decenas);
            case 3:
                return 'TRESCIENTOS ' + Decenas(decenas);
            case 4:
                return 'CUATROCIENTOS ' + Decenas(decenas);
            case 5:
                return 'QUINIENTOS ' + Decenas(decenas);
            case 6:
                return 'SEISCIENTOS ' + Decenas(decenas);
            case 7:
                return 'SETECIENTOS ' + Decenas(decenas);
            case 8:
                return 'OCHOCIENTOS ' + Decenas(decenas);
            case 9:
                return 'NOVECIENTOS ' + Decenas(decenas);
        }

        return Decenas(decenas);
    }

    function Seccion(num, divisor, strSingular, strPlural) {
        let cientos = Math.floor(num / divisor)
        let resto = num - (cientos * divisor)

        let letras = '';

        if (cientos > 0)
            if (cientos > 1)
                letras = Centenas(cientos) + ' ' + strPlural;
            else
                letras = strSingular;

        if (resto > 0)
            letras += '';

        return letras;
    }

    function Miles(num) {
        let divisor = 1000;
        let cientos = Math.floor(num / divisor)
        let resto = num - (cientos * divisor)

        let strMiles = Seccion(num, divisor, 'UN MIL', 'MIL');
        let strCentenas = Centenas(resto);

        if (strMiles == '')
            return strCentenas;

        return strMiles + ' ' + strCentenas;
    }

    function Millones(num) {
        let divisor = 1000000;
        let cientos = Math.floor(num / divisor)
        let resto = num - (cientos * divisor)

        let strMillones = Seccion(num, divisor, 'UN MILLON DE', 'MILLONES DE');
        let strMiles = Miles(resto);

        if (strMillones == '')
            return strMiles;

        return strMillones + ' ' + strMiles;
    }

    return function NumeroALetras(num, currency) {
        currency = currency || {};
        let data = {
            numero: num,
            enteros: Math.floor(num),
            centavos: (((Math.round(num * 100)) - (Math.floor(num) * 100))),
            letrasCentavos: '',
            letrasMonedaPlural: currency.plural || 'PESOS CHILENOS',
            letrasMonedaSingular: currency.singular || 'PESO CHILENO',
            letrasMonedaCentavoPlural: currency.centPlural || 'CHIQUI PESOS CHILENOS',
            letrasMonedaCentavoSingular: currency.centSingular || 'CHIQUI PESO CHILENO'
        };

        if (data.centavos > 0) {
            data.letrasCentavos = 'CON ' + (function () {
                if (data.centavos == 1)
                    return Millones(data.centavos) + ' ' + data.letrasMonedaCentavoSingular;
                else
                    return Millones(data.centavos) + ' ' + data.letrasMonedaCentavoPlural;
            })();
        }
        ;

        if (data.enteros == 0)
            return 'CERO ' + data.letrasMonedaPlural + ' ' + data.letrasCentavos;
        if (data.enteros == 1)
            return Millones(data.enteros) + ' ' + data.letrasMonedaSingular + ' ' + data.letrasCentavos;
        else
            return Millones(data.enteros) + ' ' + data.letrasMonedaPlural + ' ' + data.letrasCentavos;
    };

});

var numero = {
    UNIDADES: ["", "uno ", "dos ", "tres ", "cuatro ", "cinco ", "seis ", "siete ", "ocho ", "nueve "],
    DECENAS: ["diez ", "once ", "doce ", "trece ", "catorce ", "quince ", "dieciseis ", "diecisiete ", "dieciocho ", "diecinueve ", "veinte ", "treinta ", "cuarenta ", "cincuenta ", "sesenta ", "setenta ", "ochenta ", "noventa "],
    CENTENAS: ["", "ciento ", "doscientos ", "trescientos ", "cuatrocientos ", "quinientos ", "seiscientos ", "setecientos ", "ochocientos ", "novecientos "],
    letras: function(numero,moneda, uppercase) {
        var literal = "", parteDecimal, isUpperCase = true;
        var money = moneda || 'Soles';
        // console.log(moneda);
        if(typeof uppercase == "boolean") {
            isUpperCase = uppercase;
        }

        numero = numero.toString().replace(".", ",");

        if(numero.indexOf(",") == -1) {
            numero += ",00";
        }

        if (numero.match("\\d{1,9},\\d{1,2}")) {
            var Num = numero.split(",");
            parteDecimal = Num[1] + "/100 "+money;

            if (parseInt(Num[0]) == 0) {//si el valor es cero
                literal = "cero ";
            } else if (parseInt(Num[0]) > 999999) {//si es millon
                literal = this.getMillones(Num[0]);
            } else if (parseInt(Num[0]) > 999) {//si es miles
                literal = this.getMiles(Num[0]);
            } else if (parseInt(Num[0]) > 99) {//si es centena
                literal = this.getCentenas(Num[0]);
            } else if (parseInt(Num[0]) > 9) {//si es decena
                literal = this.getDecenas(Num[0]);
            } else {//sino unidades -> 9
                literal = this.getUnidades(Num[0]);
            }
            //devuelve el resultado en mayusculas o minusculas
            if (isUpperCase) {
                return (literal + " CON " + parteDecimal).toUpperCase();
            } else {
                return (literal + " con " + parteDecimal);
            }
        }
        else {
            return null;
        }
    },
    getUnidades: function(numero) {
        var num = numero.substring(numero.toString().length - 1);
        return this.UNIDADES[parseInt(num)];
    },
    getDecenas: function(num) {
        var n = parseInt(num);
        if (n < 10) {
            //para casos como -> 01 - 09
            return this.getUnidades(num);
        } else if (n > 19) {
            //para 20...99
            var u = this.getUnidades(num);
            if (u == "") {
                //para 20,30,40,50,60,70,80,90
                return this.DECENAS[parseInt(num.substring(0, 1)) + 8];
            } else {
                if(n > 20 && n < 30)
                    return "veinti" + u;
                else
                    return this.DECENAS[parseInt(num.substring(0, 1)) + 8] + "y " + u;
            }
        } else {
            //numeros entre 11 y 19
            return this.DECENAS[n - 10];
        }
    },
    getCentenas: function(num) {// 999 o 099
        if( parseInt(num)>99 ){//es centena
            if (parseInt(num) == 100) {//caso especial
                return "cien ";
            } else {
                return this.CENTENAS[parseInt(num.substring(0, 1))] + this.getDecenas(num.substring(1));
            }
        }else{//por Ej. 099
            //se quita el 0 antes de convertir a decenas
            return this.getDecenas(parseInt(num)+"");
        }
    },
    getMiles: function(numero) {// 999 999
        //obtiene las centenas
        var c = numero.substring(numero.toString().length - 3);
        //obtiene los miles
        var m = numero.substring(0, numero.toString().length - 3);
        var n="";
        //se comprueba que miles tenga valor entero
        if (parseInt(m) > 0) {
            n = (Number(m) > 1) ? this.getCentenas(m) : "";
            return n + "mil " + this.getCentenas(c);
        } else {
            return "" + this.getCentenas(c);
        }
    },
    getMillones: function(numero) { //000 000 000
        //se obtiene los miles
        var miles = numero.substring(numero.toString().length - 6);
        //se obtiene los millones
        var millon = numero.substring(0, numero.toString().length - 6);
        var n = "";
        if(millon.toString().length > 1){
            n = this.getCentenas(millon) + "millones ";
        }else{
            n = this.getUnidades(millon) + "millon ";
        }
        return n + this.getMiles(miles);
    },
    getRound: function(num) {
        var n = parseFloat(num);
        var result = Math.round((num + Number.EPSILON) * 100) / 100;
        return result;
    },
};
