@extends('base.base_login')
@section('title', 'Inicio sesión')
@section('content')
    {{--<div class="accountbg"></div>--}}
    <div class="wrapper__bglogin"></div>
    <img class="bg-login" src="img/bg-login.png">
    <div class="wrapper-page">
        <div class="card card-pages shadow-none">
            <div class="card-body">
                <div class="text-center m-t-0 m-b-15">
                    <a href="/" class="logo logo-admin">
                        {{--<img src="{{url('/')}}/stexo/assets/images/logo-dark.png" alt="" height="24">--}}
                        <h4 class="bold text-primary">Company ERP</h4>
                    </a>
                </div>
                <h5 class="font-18 text-center">Iniciar Sesión.</h5>
                <form action="/login/form" class="form-horizontal m-t-30" method="post">
                    @csrf
                    {{--{{ csrf_field() }}--}}

                    @if (count($errors))
                        @foreach($errors->all() as $error)
                            <div class="alert alert-danger alert-dismissable">
                                <a href="#" class="close" data-dismiss="alert" aria-label="close">×</a>
                                <strong>{{$error}}</strong>
                            </div>
                        @endforeach
                    @endif

                    <div class="form-group">
                        {{--<div class="col-12">--}}
                            {{--<label>Nombre usuario</label>--}}
                            {{--<input class="form-control" type="text" required name="username" maxlength="20"--}}
                                   {{--placeholder="Nombre de usuario">--}}
                        {{--</div>--}}
                        <div class="col-12">
                            <label>Correo electrónico</label>
                            <div class="input-group">
                                <div class="input-group-prepend">
                                    <span class="input-group-text">
                                        <i class="fas fa-envelope"></i>
                                    </span>
                                </div>
                                <input class="form-control" type="email" required name="email"
                                       value="{{ old('email') }}"
                                       placeholder="Correo electrónico">
                            </div>
                        </div>
                    </div>

                    <div class="form-group">
                        <div class="col-12">
                            <label>Contraseña</label>
                            <div class="input-group">
                                <div class="input-group-prepend">
                                    <span class="input-group-text">
                                        <i class="fas fa-lock"></i>
                                    </span>
                                </div>
                                <input class="form-control" type="password" required name="password" maxlength="20"
                                       placeholder="Contraseña">
                            </div>
                        </div>
                    </div>

                    <div class="form-group text-center m-t-20">
                        <div class="col-12">
                            <button class="btn btn-primary btn-block btn-lg waves-effect waves-light" type="submit">
                                Iniciar
                                Sesión
                            </button>
                        </div>
                    </div>
                </form>
            </div>

        </div>
    </div>
@endsection
