@extends('system.base')
@section('content')

    <div class="col-lg-12 col-md-12 col-sm-12 col-12">
        <div class="page-title-box form__head">
            <div class="row align-items-center">
                <div class="col-sm-6">
                    <h4 class="page-title form__head__title">
                        @if($is_create)
                            <span>Registrar ciclo de activación</span>
                        @else
                            <span>Editar plan empresarial</span>
                        @endif

                    </h4>
                </div>
                <div class="col-sm-6 form__head__boxBtn">
                    <p class="m-b-0 m-t-5">Campos requeridos (<span class="required-top">*</span>)</p>
                </div>
            </div> <!-- end row -->
        </div>
    </div>

    <div class="col-lg-12">
        <div class="card m-b-30">
            <div class="card-body">

                @if ($errors->any())
                    <div class="alert alert-danger p-10">
                        <ul class="m-0">
                            @foreach ($errors->all() as $error)
                                <li>{{ $error }}</li>
                            @endforeach
                        </ul>
                    </div>
                @endif

                @if($is_create)
                    <form action="{{route('system.activations_save')}}" method="post" class="row">
                        {!! csrf_field() !!}

                        <div class="form-group col-lg-6">
                            <label>Seleccionar empresa <span class="required"></span></label>
                            <select class="form-control" name="company_id">
                                <option value="0">SELECCIONAR EMPRESA</option>
                                @foreach($companies as $item)
                                    <option value="{{$item->id}}">{{$item->name_complete}}</option>
                                @endforeach
                            </select>
{{--                            <input type="text" class="form-control text-uppercase" name="description" required>--}}
{{--                            <input type="hidden" name="company_id" id="company_id">--}}
                        </div>
                        <div class="form-group col-lg-2">
                            <label>Fecha de Inicio <span class="required"></span></label>
                            <input type="date" class="form-control text-uppercase" name="date_start" required>
                        </div>
                        <div class="form-group col-lg-2">
                            <label>Fecha de Finalización <span class="required"></span></label>
                            <input type="date" class="form-control text-uppercase" name="date_end" required>
                        </div>
                        <div class="form-group col-lg-2">
                            <label>Monto a pagar S/ <span class="required"></span></label>
                            <input type="number" class="form-control" name="amount" required>
                        </div>
                        <div class="form-group col-lg-6">
                            <label>Observación</label>
                            <input type="text" class="form-control text-uppercase" name="observation" >
                        </div>
                        <div class="form-group col-lg-12 form__footerBtn">
                            <div class="text-right">
                                <a href="{{route('system.activations')}}" class="btn btn-secondary waves-effect m-l-5">
                                    Cancelar
                                </a>
                                <button type="submit" class="btn btn-primary waves-effect waves-light">
                                    Guardar
                                </button>
                            </div>
                        </div>
                    </form>
                @else
                        <form action="{{route('system.activations_update',['id'=>$item->id])}}" method="post" class="row">
                            {!! csrf_field() !!}

                            <div class="form-group col-lg-6">
                                <label>Seleccionar empresa <span class="required"></span></label>
                                <select class="form-control" name="company_id">
                                    @foreach($companies as $company)
                                        @if($item->company_id == $company->id)
                                            <option selected="true" value="{{$company->id}}">{{$company->name_complete}}</option>
                                        @else
                                            <option value="{{$item->id}}">{{$company->name_complete}}</option>
                                        @endif
                                    @endforeach
                                </select>
                            </div>
                            <div class="form-group col-lg-2">
                                <label>Fecha de Inicio <span class="required"></span></label>
                                <input type="date" class="form-control text-uppercase" name="date_start" required value="{{$item->date_start}}">
                            </div>
                            <div class="form-group col-lg-2">
                                <label>Fecha de Finalización <span class="required"></span></label>
                                <input type="date" class="form-control text-uppercase" name="date_end" required value="{{$item->date_end}}">
                            </div>
                            <div class="form-group col-lg-2">
                                <label>Monto a pagar S/ <span class="required"></span></label>
                                <input type="number" class="form-control" name="amount" required value="{{$item->amount}}">
                            </div>
                            <div class="form-group col-lg-6">
                                <label>Observación</label>
                                <input type="text" class="form-control text-uppercase" name="observation" value="{{$item->observation}}">
                            </div>
                            <div class="form-group col-lg-3">
                                <label>Estado</label>
                                <select class="form-control" name="is_active">
                                    @if($item->is_active == true)
                                        <option selected="selected" value="true">Activado</option>
                                        <option value="false">Desactivar</option>
                                    @else
                                        <option selected="true" value="false">Desactivado</option>
                                        <option value="true">Activar</option>
                                    @endif
                                </select>
                            </div>



                            <div class="form-group col-lg-12 form__footerBtn">
                                <div class="text-right">
                                    <a href="{{route('system.activations')}}" class="btn btn-secondary waves-effect m-l-5">
                                        Cancelar
                                    </a>
                                    <button type="submit" class="btn btn-primary waves-effect waves-light">
                                        Guardar cambios
                                    </button>
                                </div>
                            </div>
                        </form>
                @endif
            </div>
        </div>
    </div>
@endsection

