@extends('system.base')
@section('content')
    <div class="row">
        <div class="col-lg-12 col-md-12 col-sm-12 col-12">
            <div class="page-title-box">
                <div class="row align-items-center">
                    <div class="col-sm-6 col-md-6 col-sm-6 col-12">
                        <h4 class="page-title content__title">Activaciones de empresas</h4>
                    </div>
                    <div class="col-sm-6 col-sm-6 col-md-6 col-sm-6 col-12 text-right">
                        <a href="{{route('system.activations_create')}}" class="btn btn-primary waves-effect waves-light">
                            <i class="fa fa-plus m-r-5"></i> Crear activación
                        </a>
                    </div>
                </div> <!-- end row -->
            </div>
        </div>
        <div class="col-lg-12 col-lg-12 col-md-12 col-sm-12 col-12">
            <div class="card m-b-30">
                <div class="card-body">
                    <div class="table-responsive">
                        <table class="table table-hover">
                            <thead>
                            <tr>
                                <th scope="col">RUC</th>
                                <th scope="col">RAZON SOCIAL</th>
                                <th class="text-center">Fecha Inicio</th>
                                <th class="text-center">Fecha Finalización</th>
                                <th>Estado</th>
                                <th></th>
                            </tr>
                            </thead>
                            <tbody>
                            @if(count($items)==0)
                                <tr class="text-center">
                                    <td colspan="3">No se encontraron registros</td>
                                </tr>
                            @else
                                @foreach($items as $item)
                                    <tr>
                                        <td>{{$item->company_data->ruc}}</td>
                                        <td>{{$item->company_data->social_reason}}</td>
                                        <td class="text-center">{{$item->date_start}}</td>
                                        <td class="text-center">{{$item->date_end}}</td>
                                        <td>
                                            @if($item->is_active)
                                                <span class="badge badge-success f-s-12">Activo</span>
                                            @else
                                                <span class="badge badge-warning f-s-12">Desactivado</span>
                                            @endif
                                        </td>
                                        <td class="text-center">
                                            <a href="{{route('system.activations_edit',['id'=>$item->id])}}" title="Editar"
                                               class="btn btn-sm btn-primary"><i class="fas fa-pen-alt"></i></a>
{{--                                            <a onclick="deleteObj('{{route('system.plans_destroy',['id'=>$item->id])}}')"--}}
{{--                                               title="Borrar" class="btn btn-sm btn-danger text-white m-l-5 pointer"><i--}}
{{--                                                        class="fa fa-trash action"></i></a>--}}
                                        </td>
                                    </tr>
                                @endforeach
                            @endif
                            </tbody>
                        </table>
                    </div>

                </div>
            </div>
        </div>
    </div>
@endsection
