<!DOCTYPE html>
<html lang="es">

<head>
    <meta charset="utf-8"/>
    <meta http-equiv="X-UA-Compatible" content="IE=edge">
    <meta name="viewport" content="width=device-width, initial-scale=1.0, user-scalable=0, minimal-ui">
    <meta name="csrf-token" content="{{ csrf_token() }}">

    <title>{{config('app.name')}}</title>

    <link href="{{url('/')}}/stexo/assets/images/favicon.ico" rel="stylesheet">
    <link href="{{url('/')}}/stexo/assets/images/favicon.ico" rel="stylesheet">
    <link href="{{url('/')}}/stexo/assets/css/bootstrap.min.css" rel="stylesheet">
    <link href="{{url('/')}}/stexo/assets/css/metismenu.min.css" rel="stylesheet">

    <link href="{{url('/')}}/stexo/plugins/sweet-alert2/sweetalert2.css" rel="stylesheet">


    <link href="{{url('/')}}/stexo/assets/css/icons.css" rel="stylesheet">
    <link href="{{url('/')}}/stexo/assets/css/style.css" rel="stylesheet">

    <!--stylus encoder -->
    <link href="{{url('/')}}/design/tinku.css" rel="stylesheet">
</head>

<body>

<!-- Begin page -->
<div id="wrapper">

    <!-- Top Bar Start -->
    <div class="topbar">

        <!-- LOGO -->
        <div class="topbar-left" style="background: #1c2227;">
            <a href="index.html" class="logo">
                        <span class="logo-light">
                            <i class="mdi mdi-camera-control"></i> Stexo
                        </span>
                <span class="logo-sm">
                            <i class="mdi mdi-camera-control"></i>
                        </span>
            </a>
        </div>

        <nav class="navbar-custom">
            <ul class="navbar-right list-inline float-right mb-0">
                <li class="dropdown notification-list list-inline-item">
                    <div class="dropdown notification-list nav-pro-img">
                        <a class="dropdown-toggle nav-link arrow-none nav-user" data-toggle="dropdown" href="#"
                           role="button" aria-haspopup="false" aria-expanded="false">
                            <img src="{{url('/')}}/img/user_default.png" alt="user" class="rounded-circle">
                        </a>
                        <div class="dropdown-menu dropdown-menu-right profile-dropdown ">
                            <!-- item-->
                            <a class="dropdown-item"><i class="mdi mdi-account-circle"></i> {{\Auth::user()->name}}</a>
                            <div class="dropdown-divider"></div>
                            <a class="dropdown-item text-danger" href="/logout"><i class="mdi mdi-power text-danger"></i>
                                Cerrar Sesión
                            </a>
                        </div>
                    </div>
                </li>
            </ul>

            <ul class="list-inline menu-left mb-0">
                <li class="float-left">
                    <button class="button-menu-mobile open-left waves-effect">
                        <i class="mdi mdi-menu"></i>
                    </button>
                </li>
            </ul>

        </nav>

    </div>
    <!-- Top Bar End -->

    <!-- ========== Left Sidebar Start ========== -->
    <div class="left side-menu" style="background: #1c2227;">
        <div class="slimscroll-menu" id="remove-scroll">

            <!--- Sidemenu -->
            <div id="sidebar-menu">
                <!-- Left Menu Start -->
                <ul class="metismenu" id="side-menu">
                    <li class="menu-title">Menu</li>
                    <li>
                        <a href="{{route('system.dashboard')}}" class="waves-effect">
                            <i class="icon-accelerator"></i>
                            <span> Dashboard </span>
                        </a>
                    </li>

                    <li>
                        <a href="{{route('system.company')}}" class="waves-effect">
                            <i class="fas fa-archway"></i>
                            <span>Empresas</span>
                        </a>
                    </li>

                    <li>
                        <a href="{{route('system.profiles')}}" class="waves-effect">
                            <i class="fas fa-users"></i>
                            <span>Perfiles</span>
                        </a>
                    </li>
                    <li>
                        <a href="{{route('system.plans')}}" class="waves-effect">
                            <i class="far fa-paper-plane"></i>
                            <span>Planes empresas</span>
                        </a>
                    </li>

                    <li>
                        <a href="{{route('system.activations')}}" class="waves-effect">
                            <i class="far fa-money-bill-alt"></i>
                            <span>Activaciones</span>
                        </a>
                    </li>

                </ul>

            </div>
            <!-- Sidebar -->
            <div class="clearfix"></div>

        </div>
        <!-- Sidebar -left -->

    </div>
    <!-- Left Sidebar End -->

    <!-- ============================================================== -->
    <!-- Start right Content here -->
    <!-- ============================================================== -->
    <div class="content-page">
        <!-- Start content -->
        <div class="content">
            <div class="container-fluid">
                @section("content")

                @show

            </div>
            <!-- container-fluid -->

        </div>
        <!-- content -->
    </div>
    <!-- ============================================================== -->
    <!-- End Right content here -->
    <!-- ============================================================== -->

</div>
<!-- END wrapper -->


<!-- jQuery  -->
<script src="{{url('/')}}/stexo/assets/js/jquery.min.js"></script>
<script src="{{url('/')}}/stexo/assets/js/bootstrap.bundle.min.js"></script>
<script src="{{url('/')}}/stexo/assets/js/metismenu.min.js"></script>
<script src="{{url('/')}}/stexo/assets/js/jquery.slimscroll.js"></script>
<script src="{{url('/')}}/stexo/assets/js/waves.min.js"></script>

<script src="{{url('/')}}/stexo/plugins/sweet-alert2/sweetalert2.min.js"></script>


<script src="{{url('/')}}/stexo/assets/js/app.js"></script>
<script src="{{url('/')}}/js/helpers.js"></script>

@yield("js")@show

</body>
</html>
