@extends('system.base')
@section('content')
    <div class="row">
        <div class="col-lg-12 col-md-12 col-sm-12 col-12">
            <div class="page-title-box">
                <div class="row align-items-center">
                    <div class="col-sm-6 col-md-6 col-sm-6 col-12">
                        <h4 class="page-title content__title">Empresas afiliadas</h4>
                    </div>
                    <div class="col-sm-6 col-sm-6 col-md-6 col-sm-6 col-12 text-right">
                        <a href="{{route('system.company_create')}}" class="btn btn-primary waves-effect waves-light">
                            <i class="fa fa-plus m-r-5"></i> Crear empresa
                        </a>
                    </div>
                </div> <!-- end row -->
            </div>
        </div>
        <div class="col-lg-12 col-lg-12 col-md-12 col-sm-12 col-12">
            <div class="card m-b-30">
                <div class="card-body">
                    <div class="table-responsive">
                        <table class="table table-hover">
                            <thead>
                            <tr>
                                <th scope="col">Dominio</th>
                                <th scope="col">RUC</th>
                                <th scope="col">Razón Social</th>
                                <th scope="col">Api facturador</th>
                                <th scope="col">Plan</th>
                            </tr>
                            </thead>
                            <tbody>
                            @if(count($items)==0)
                                <tr class="text-center">
                                    <td colspan="3">No se encontraron registros</td>
                                </tr>
                            @else
                                @foreach($items as $item)
                                    <tr>
                                        <td>
                                            <a href="{{config('app.base_url')}}{{$item->domain}}" target="_blank">{{$item->domain}}</a>
                                        </td>
                                        <td>{{$item->ruc}}</td>
                                        <td>{{$item->social_reason}}</td>
                                        <td>{{$item->api_facturador}}</td>
                                        <td>{{$item->plan}}</td>
                                    </tr>
                                @endforeach
                            @endif
                            </tbody>
                        </table>
                    </div>

                </div>
            </div>
        </div>
    </div>
@endsection