@extends('system.base')
@section('content')

    <div class="col-lg-12 col-md-12 col-sm-12 col-12">
        <div class="page-title-box form__head">
            <div class="row align-items-center">
                <div class="col-sm-6">
                    <h4 class="page-title form__head__title">Registrar empresa</h4>
                </div>
                <div class="col-sm-6 form__head__boxBtn">
                    <p class="m-b-0 m-t-5">Campos requeridos (<span class="required-top">*</span>)</p>
                </div>
            </div> <!-- end row -->
        </div>
    </div>

    <div class="col-lg-12">
        <div class="card m-b-30">
            <div class="card-body">

                @if ($errors->any())
                    <div class="alert alert-danger p-10">
                        <ul class="m-0">
                            @foreach ($errors->all() as $error)
                                <li>{{ $error }}</li>
                            @endforeach
                        </ul>
                    </div>
                @endif

                <form action="{{route('system.company_save')}}" method="post" class="row" enctype="multipart/form-data">
                    {!! csrf_field() !!}
                    <div class="form-group col-lg-8">
                        <label>Razón social<span class="required"></span></label>
                        <input type="text"
                               required="required"
                               name="social_reason"
                               value="BANNER SALINAS PANAIJO"
                               class="form-control">
                    </div>
                    <div class="form-group col-lg-4">
                        <label>N° de RUC<span class="required"></span></label>
                        <input type="text"
                               required="required"
                               name="ruc"
                               value="10482859921"
                               class="form-control">
                    </div>
                    <div class="form-group col-lg-12">
                        <label>Nombre comercial</label>
                        <input type="text"
                               name="tradename"
                               class="form-control">
                    </div>
                    <div class="form-group col-lg-4">
                        <label>Hostname<span class="required"></span></label>
                        <div class="input-group">
                            <input type="text"
                                   required="required"
                                   name="hostname"
                                   class="form-control">
                            <div class="input-group-append">
                                <span class="input-group-text">
                                    {{$domain}}
                                </span>
                            </div>
                        </div>
                    </div>
                    <div class="form-group col-lg-4">
                        <label>Categoría empresa <span class="required"></span></label>
                        <select class="form-control" name="category_id">
                            @foreach($categories as $item)
                                <option value="{{$item->id}}">{{$item->description}}</option>
                            @endforeach
                        </select>
                    </div>
                    <div class="form-group col-lg-4">
                        <label>Plan Asignado <span class="required"></span></label>
                        <select class="form-control" name="plan_id">
                            @foreach($plans as $item)
                                <option value="{{$item->id}}">{{$item->description}}</option>
                            @endforeach
                        </select>
                    </div>
                    <div class="form-group col-lg-4">
                        <label>Api facturador <span class="required"></span></label>
                        <input type="text"
                               required="true"
                               name="api_facturador"
                               value="http://test.sisfactura.com"
                               class="form-control">
                    </div>
                    <div class="form-group col-lg-8">
                        <label>Api Token<span class="required"></span></label>
                        <input type="text"
                               required="true"
                               name="api_token"
                               value="bQYMgjYSzqSKxcZte1ijDmyhQcieNK622X9lk0Pc593S6Qtzrh"
                               class="form-control">
                    </div>

                    <div class="form-group col-lg-4">
                        <label>Código ubigeo<span class="required"></span></label>
                        <input type="text"
                               required="required"
                               name="ubigeo"
                               value="220901"
                               class="form-control">
                    </div>
                    <div class="form-group col-lg-8">
                        <label>Dirección principal<span class="required"></span></label>
                        <textarea class="form-control no-resize" name="address" rows="1"></textarea>
                    </div>

                    <div class="form-group col-lg-4">
                        <label>N° Celular</label>
                        <input type="text" class="form-control" name="cellphone">
                    </div>
                    <div class="form-group col-lg-4">
                        <label>N° Teléfono</label>
                        <input type="text" class="form-control" name="telephone">
                    </div>
                    <div class="form-group col-lg-4">
                        <label>Correo electrónico</label>
                        <input type="email" class="form-control" name="email">
                    </div>
                    <div class="form-group col-lg-4">
                        <label>Logo empresa</label>
                        {{--<input type="email" class="form-control" name="email">--}}
                        <input name="url_image" type="file" id="url_image">
                    </div>


                    <div class="form-group col-lg-12 form__footerBtn">
                        <div class="text-right">
                            <a href="{{route('system.company')}}" class="btn btn-secondary waves-effect m-l-5">
                                Cancelar
                            </a>
                            <button type="submit" class="btn btn-primary waves-effect waves-light">
                                Guardar
                            </button>
                        </div>
                    </div>

                </form>
            </div>
        </div>
    </div>
@endsection

