@extends('system.base')
@section('content')

    <div class="col-lg-12 col-md-12 col-sm-12 col-12">
        <div class="page-title-box form__head">
            <div class="row align-items-center">
                <div class="col-sm-12">
                    <a href="{{route('system.profiles')}}">
                        <h4 class="page-title form__head__title">
                            <i class="fas fa-arrow-left m-r-5"></i>
                            <span class="light">Assignar módulos del perfil : </span>
                            <span class="bold">{{$profile->description}}</span>
                        </h4>
                    </a>
                </div>
            </div> <!-- end row -->
        </div>
    </div>

    <div class="col-lg-12">
        <div class="card m-b-30">
            <div class="card-body">
                @if ($errors->any())
                    <div class="alert alert-danger p-10">
                        <ul class="m-0">
                            @foreach ($errors->all() as $error)
                                <li>{{ $error }}</li>
                            @endforeach
                        </ul>
                    </div>
                @endif
                <div class="alert alert-info">
                    <strong>Importante!</strong>, para asiganar los módulos hijos deberá marcar al módulo padre
                </div>

                @if (Session::has('msg'))
                    <div class="alert alert-warning alert-dismissable">
                        <a href="#" class="close" data-dismiss="alert" aria-label="close">×</a>
                        <strong>Advertencia! </strong>{!! Session::has('msg') ? Session::get("msg") : '' !!}.
                    </div>
                @endif

                <form action="{{route('system.profiles_assingmodules_save',['id'=>$profile->id])}}" method="post"
                      class="row">
                    {!! csrf_field() !!}

                    <input type="hidden" value="{{$profile->id}}" name="profile_id">

                    @foreach ($modules as $module)
                        <div class="col-lg-12 m-b-15">
                            <div class="custom-control custom-checkbox m-t-5">
                                <input type="checkbox" class="custom-control-input"
                                       id="module{{$module->id}}"
                                       value="{{$module->id}}"
                                       name="module_assing[]">
                                <label class="custom-control-label p-t-3" for="module{{$module->id}}">
                                    <i class="{{$module->icon}} m-r-5"></i>{{$module->name}}
                                </label>
                            </div>
                            <hr class="m-t-10 m-b-0">
                            <div class="row">
                                <div class="col-lg-12 p-l-40">
                                    <div class="flex">
                                        @foreach($module->childsmodule as $child)
                                            <div class="custom-control custom-checkbox m-t-5 m-r-15">
                                                <input type="checkbox" class="custom-control-input"
                                                       id="module{{$child->id}}"
                                                       value="{{$child->id}}"
                                                       name="module_assing[]">
                                                <label class="custom-control-label p-t-3"
                                                       for="module{{$child->id}}">{{$child->name}}</label>
                                            </div>
                                        @endforeach
                                    </div>
                                </div>
                            </div>
                        </div>
                    @endforeach
                    <div class="form-group col-lg-12 form__footerBtn">
                        <div class="text-right">
                            <a href="{{route('system.profiles')}}" class="btn btn-secondary waves-effect m-l-5">
                                Cancelar
                            </a>
                            <button type="submit" class="btn btn-primary waves-effect waves-light">
                                Guardar cambios
                            </button>
                        </div>
                    </div>
                </form>
            </div>
        </div>
    </div>
@endsection
@section("js")
    <script>
        let route = '{{route('system.modules_byprofile',['id'=>$profile->id])}}';
        setTimeout(function () {
            $.get(route, function (data) {
                let modules = data.results;
                $.each(modules, function (i, item) {
                    $("#module" + item.id).prop('checked', true);
                });
            });
        }, 200);
    </script>
@stop
