@extends('system.base')
@section('content')

    <div class="col-lg-12 col-md-12 col-sm-12 col-12">
        <div class="page-title-box form__head">
            <div class="row align-items-center">
                <div class="col-sm-6">
                    <h4 class="page-title form__head__title">
                        @if($is_create)
                            <span>Registrar perfil</span>
                        @else
                            <span>Editar perfil</span>
                        @endif

                    </h4>
                </div>
                <div class="col-sm-6 form__head__boxBtn">
                    <p class="m-b-0 m-t-5">Campos requeridos (<span class="required-top">*</span>)</p>
                </div>
            </div> <!-- end row -->
        </div>
    </div>

    <div class="col-lg-12">
        <div class="card m-b-30">
            <div class="card-body">

                @if ($errors->any())
                    <div class="alert alert-danger p-10">
                        <ul class="m-0">
                            @foreach ($errors->all() as $error)
                                <li>{{ $error }}</li>
                            @endforeach
                        </ul>
                    </div>
                @endif

                @if($is_create)
                    <form action="{{route('system.profiles_save')}}" method="post" class="row">
                        {!! csrf_field() !!}

                        <div class="form-group col-lg-4">
                            <label>Nombre perfil <span class="required"></span></label>
                            <input type="text" class="form-control text-uppercase" name="description" required>
                        </div>

                        <div class="form-group col-lg-12 form__footerBtn">
                            <div class="text-right">
                                <a href="{{route('system.profiles')}}" class="btn btn-secondary waves-effect m-l-5">
                                    Cancelar
                                </a>
                                <button type="submit" class="btn btn-primary waves-effect waves-light">
                                    Guardar
                                </button>
                            </div>
                        </div>
                    </form>
                @else
                        <form action="{{route('system.profiles_update',['id'=>$item->id])}}" method="post" class="row">
                            {!! csrf_field() !!}

                            <div class="form-group col-lg-4">
                                <label>Nombre perfil <span class="required"></span></label>
                                <input type="text" class="form-control text-uppercase" name="description" required value="{{$item->description}}">
                            </div>

                            <div class="form-group col-lg-12 form__footerBtn">
                                <div class="text-right">
                                    <a href="{{route('system.profiles')}}" class="btn btn-secondary waves-effect m-l-5">
                                        Cancelar
                                    </a>
                                    <button type="submit" class="btn btn-primary waves-effect waves-light">
                                        Guardar cambios
                                    </button>
                                </div>
                            </div>
                        </form>
                @endif
            </div>
        </div>
    </div>
@endsection

