@extends('system.base')
@section('content')
    <div class="row">
        <div class="col-lg-12 col-md-12 col-sm-12 col-12">
            <div class="page-title-box">
                <div class="row align-items-center">
                    <div class="col-sm-6 col-md-6 col-sm-6 col-12">
                        <h4 class="page-title content__title">Perfiles de usuario</h4>
                    </div>
                    <div class="col-sm-6 col-sm-6 col-md-6 col-sm-6 col-12 text-right">
                        <a href="{{route('system.profiles_create')}}" class="btn btn-primary waves-effect waves-light">
                            <i class="fa fa-plus m-r-5"></i> Crear perfil
                        </a>
                    </div>
                </div> <!-- end row -->
            </div>
        </div>
        <div class="col-lg-12 col-lg-12 col-md-12 col-sm-12 col-12">
            <div class="card m-b-30">
                <div class="card-body">
                    <div class="table-responsive">
                        <table class="table table-hover">
                            <thead>
                            <tr>
                                <th scope="col">Perfil usuario</th>
                                <th scope="col">N° módulos asignados</th>
                                <th scope="col">Módulos</th>
                                <th scope="col">Permisos</th>
                                <th scope="col"></th>
                            </tr>
                            </thead>
                            <tbody>
                            @if(count($items)==0)
                                <tr class="text-center">
                                    <td colspan="3">No se encontraron registros</td>
                                </tr>
                            @else
                                @foreach($items as $item)
                                    <tr>
                                        <td>{{$item->description}}</td>
                                        <td>{{$item->countmodules}}</td>
                                        <td>
                                            <a class="btn btn-sm btn-info" href="{{route('system.profiles_assingmodules',['id'=>$item->id])}}">Asignar módulos</a>
                                        </td>
                                        <td>
                                            <a class="btn btn-sm btn-warning" href="{{route('system.profiles_assingpermissions',['id'=>$item->id])}}">Asignar permisos</a>
                                        </td>
                                        <td class="text-center">
                                            <a href="{{route('system.profiles_edit',['id'=>$item->id])}}" title="Editar"
                                               class="btn btn-sm btn-primary"><i class="fas fa-pen-alt"></i></a>
                                            {{--<a onclick="deleteObj('{{route('system.profiles_destroy')}}',{{$item->id}})"--}}
                                            <a onclick="deleteObj('{{route('system.profiles_destroy',['id'=>$item->id])}}')"
                                            {{--<a onclick="deleteObj('{{$item->id}}')"--}}
                                               title="Borrar" class="btn btn-sm btn-danger text-white m-l-5 pointer"><i
                                                        class="fa fa-trash action"></i></a>
                                        </td>
                                    </tr>
                                @endforeach
                            @endif
                            </tbody>
                        </table>
                    </div>

                </div>
            </div>
        </div>
    </div>
@endsection
