@extends('base.base_sys')
@section('title', 'Sucursales')
@section('content')
    <!-- end page-title -->
    <div class="page-title-box">
        <div class="row align-items-center m-0">
            <div class="col-sm-6">
                <h4 class="page-title bold">SISTURING</h4>
            </div>
            <div class="col-sm-6">
                <ol class="breadcrumb float-right">
                    <li class="breadcrumb-item active">
                        <span class="bold m-r-5">{{\Auth::user()->username}}</span>
                        <a class="pointer" href="/logout">
                            <i class="fas fa-sign-out-alt"></i> Cerrar sesión
                        </a>
                    </li>
                </ol>
            </div>
        </div>
        <!-- end row -->
    </div>
    <!-- end page-title -->

    <div class="row justify-content-center">
        <div class="col-md-6">
            <div class="text-center">
                <h5>Elige tu sucursal</h5>
                <p class="text-muted">-------------------------------</p>
            </div>
        </div>
    </div>
    @if (Session::has('msg'))
        <div class="alert alert-warning alert-dismissable">
            <a href="#" class="close" data-dismiss="alert" aria-label="close">×</a>
            <strong>Importante! </strong>{!! Session::has('msg') ? Session::get("msg") : '' !!}.
        </div>
    @endif

    <div class="row m-t-30 p-l-100 p-r-100">
        @foreach($branchs as $item)
            <div class="col-xl-3 col-md-6">
                <div class="card pricing-box mt-4">
                    <div class="pricing-icon">
                        <i class="fas fa-store-alt bg-primary"></i>
                    </div>
                    <div class="pricing-content">
                        <div class="pricing-features mt-4">
                            <p class="mb-2 text-center bold f-s-16 text-uppercase">{{$item->description}}</p>
                            <p class="font-14 mb-2">
                                <i class="ti-check-box text-success mr-2"></i>
                                {{$item->address}}
                            </p>
                        </div>
                        <div class="mt-4 pt-3 text-center">
                            {{--<a href="http://demo.multi.corp/" class="btn btn-light btn-round m-r-15"><i--}}
                                        {{--class="fas fa-cog m-r-5"></i>Ajustes</a>--}}
                            <form action="{{route('tenant.company.select_branchoffice')}}" method="POST">
                                {!! csrf_field() !!}
                                <input type="hidden" value="{{$item->id}}" name="branchoffice_id">
                                <button type="submit" class="btn btn-primary btn-round">Ir a empresa <i
                                            class="fas fa-arrow-right m-l-5"></i></button>
                            </form>
                        </div>
                    </div>
                </div>
            </div>
        @endforeach
    </div>

@endsection