<?php

Route::group(['prefix' => '/api', 'middleware' => 'auth'], function () {

    Route::get('/config', 'Api\AppApiController@config');

    // dashboard
    Route::get('/dashboard', 'Api\Dashboard\DashboardController@index');


    // CONFIGURACIONES GENERALES ********************************

    // type transaction
    Route::get('/config/typetransaction', 'Api\Config\ConfigApiController@typeTransaction');

    // all method paids
    Route::get('/config/paymentmethod', 'Api\Config\ConfigApiController@paymentMethod');

    // currencys
    Route::get('/config/currency', 'Api\Config\ConfigApiController@currency');

    // taxes
    Route::get('/config/tax', 'Api\Config\ConfigApiController@tax');

    // type vouchers
    Route::get('/config/typevoucher', 'Api\Config\ConfigApiController@typeVoucher');
    Route::get('/config/typevoucher/purchase', 'Api\Config\ConfigApiController@typeVoucherPurchase');
    Route::get('/config/typevoucher/sale', 'Api\Config\ConfigApiController@typeVoucherSale');
    Route::get('/config/typevoucher/billing', 'Api\Config\ConfigApiController@typeVoucherBilling');
    Route::get('/config/typevoucher/notes', 'Api\Config\ConfigApiController@typeVoucherNotes');
    Route::get('/config/billingcodes/{voucher_id}', 'Api\Config\ConfigApiController@billingCodesByVoucher');

    Route::get('/config/voucher/serie/{voucher_id}', 'Api\Config\ConfigApiController@voucherSerie');

    // type documents client
    Route::get('/config/typedocument', 'Api\Config\ConfigApiController@typeDocument');

    // units of measure
    Route::get('/config/unitsmeasure/parents', 'Api\Config\ConfigApiController@unitMeasureParents');

    // units measure childs
    Route::get('/config/unitsmeasure/childs/{unit_id}', 'Api\Config\ConfigApiController@unitMeasureChilds');

    Route::get('/config/unitsmeasure/all/childs/', 'Api\Config\ConfigApiController@unitMeasureAllChilds');

    // ubigeos
    Route::get('/ubigeo/departments', 'Api\Config\ConfigApiController@ubigeoDepartments');
    Route::get('/ubigeo/provinces/{department_id}', 'Api\Config\ConfigApiController@ubigeoProvinces');
    Route::get('/ubigeo/districts/{province_id}', 'Api\Config\ConfigApiController@ubigeoDistricts');


    // COMPANY MODULE *****************************

    // ==== informacion general empresa
    Route::get('/company/information', 'Api\Company\CompanyApiController@informationCompany');
    Route::put('/company/update/information/{id}', 'Api\Company\CompanyApiController@updateInformationCompany');

    Route::get('/company/url_download_xml', 'Api\Company\CompanyApiController@getUrlDownloadXml');

    // === empleados
    Route::get('/employee/list', 'Api\Company\EmployeeApiController@index');
    Route::post('/employee/save', 'Api\Company\EmployeeApiController@store');
    Route::get('/employee/edit/{id}', 'Api\Company\EmployeeApiController@edit');
    Route::put('/employee/update/{id}', 'Api\Company\EmployeeApiController@update');
    Route::delete('/employee/delete/{id}', 'Api\Company\EmployeeApiController@destroy');
    Route::get('/employee/search/angucomplet', 'Api\Company\EmployeeApiController@searchAngucomplete');

    // ==== jobs, puestos de trabajo
    Route::get('/jobs/list', 'Api\Company\CompanyApiController@jobs');
    Route::post('/jobs/save', 'Api\Company\CompanyApiController@storeJob');
    Route::get('/jobs/edit/{id}', 'Api\Company\CompanyApiController@editJob');
    Route::put('/jobs/update/{id}', 'Api\Company\CompanyApiController@updateJob');
    Route::delete('/jobs/delete/{id}', 'Api\Company\CompanyApiController@destroyJob');
    Route::get('/jobs/search/all', 'Api\Company\CompanyApiController@allJobs');


    // CATALOG MODULE ************************************

    // ======type price
    Route::get('/catalog/typeprice', 'Api\Catalog\CatalogApiController@typePrice');

    // ===== products
    Route::get('/product/list', 'Api\Catalog\ProductApiController@index');
    Route::get('/services/list', 'Api\Catalog\ProductApiController@services');

    Route::post('/product/save', 'Api\Catalog\ProductApiController@store');
    Route::post('/services/save', 'Api\Catalog\ProductApiController@storeService');
    Route::get('/product/edit/{id}', 'Api\Catalog\ProductApiController@edit');
    Route::put('/product/update/{id}', 'Api\Catalog\ProductApiController@update');
    Route::delete('/product/delete/{id}', 'Api\Catalog\ProductApiController@destroy');

    Route::get('/product/information/detail/{id}', 'Api\Catalog\ProductApiController@informationDetail');

    Route::get('/product/favorite', 'Api\Catalog\ProductApiController@favorite');
    Route::get('/product/sale/search', 'Api\Catalog\ProductApiController@saleSearch');
    Route::get('/product/search', 'Api\Catalog\ProductApiController@search');
    Route::get('/product/search/bienes/angucomplet', 'Api\Catalog\ProductApiController@searchBienesAngucomplete');
    Route::get('/product/search/bienes/servicios/angucomplet', 'Api\Catalog\ProductApiController@searchBienesAndServiciosAngucomplete');

    Route::get('/product/batch/expiration', 'Api\Catalog\ProductApiController@batchExpiration');



    // ====== categories
    Route::get('/category/list', 'Api\Catalog\CategoryApiController@index');
    Route::post('/category/save', 'Api\Catalog\CategoryApiController@store');
    Route::get('/category/edit/{id}', 'Api\Catalog\CategoryApiController@edit');
    Route::put('/category/update/{id}', 'Api\Catalog\CategoryApiController@update');
    Route::delete('/category/delete/{id}', 'Api\Catalog\CategoryApiController@destroy');

    Route::get('/category/search/all', 'Api\Catalog\CategoryApiController@allCatgories');

    Route::get('/line/list', 'Api\Catalog\LineApiController@index');
    Route::post('/line/save', 'Api\Catalog\LineApiController@store');
    Route::get('/line/edit/{id}', 'Api\Catalog\LineApiController@edit');
    Route::put('/line/update/{id}', 'Api\Catalog\LineApiController@update');
    Route::delete('/line/delete/{id}', 'Api\Catalog\LineApiController@destroy');

    Route::get('/line/search/all', 'Api\Catalog\LineApiController@allLines');

    Route::get('/brand/list', 'Api\Catalog\BrandApiController@index');
    Route::post('/brand/save', 'Api\Catalog\BrandApiController@store');
    Route::get('/brand/edit/{id}', 'Api\Catalog\BrandApiController@edit');
    Route::put('/brand/update/{id}', 'Api\Catalog\BrandApiController@update');
    Route::delete('/brand/delete/{id}', 'Api\Catalog\BrandApiController@destroy');

    Route::get('/brand/search/all', 'Api\Catalog\BrandApiController@allBrands');

    Route::get('/variant/list', 'Api\Catalog\VariantApiController@index');
    Route::post('/variant/save', 'Api\Catalog\VariantApiController@store');
    Route::get('/variant/edit/{id}', 'Api\Catalog\VariantApiController@edit');
    Route::put('/variant/update/{id}', 'Api\Catalog\VariantApiController@update');
    Route::delete('/variant/delete/{id}', 'Api\Catalog\VariantApiController@destroy');

    Route::get('/variant/search/all', 'Api\Catalog\VariantApiController@all');

    Route::get('/variant/search/types', 'Api\Catalog\VariantApiController@typesByVariant');
//    Route::get('/variant/search/types/{variant_id}', 'Api\Config\ConfigApiController@voucherSerie');

    // // catalogo
    // require 'catalog/api_catalog.php';

    Route::get('/warehouse/concepts/entry', 'Api\Warehouse\WarehouseApiController@warehouseConceptEntry');
    Route::get('/warehouse/concepts/output', 'Api\Warehouse\WarehouseApiController@warehouseConceptOutput');

    Route::get('/warehouses/list', 'Api\Warehouse\WarehouseApiController@index');
    Route::post('/warehouses/save', 'Api\Warehouse\WarehouseApiController@store');
    Route::get('/warehouses/edit/{id}', 'Api\Warehouse\WarehouseApiController@edit');
    Route::put('/warehouses/update/{id}', 'Api\Warehouse\WarehouseApiController@update');
    Route::delete('/warehouses/delete/{id}', 'Api\Warehouse\WarehouseApiController@destroy');


    Route::get('/warehouses/principal', 'Api\Warehouse\WarehouseApiController@warehousePrincipal');
    Route::get('/warehouses/branchoffice', 'Api\Warehouse\WarehouseApiController@warehouseBranchOffice');

    Route::get('/entry/list', 'Api\Warehouse\MovementWarehouseApiController@entry');
    Route::post('/entry/save', 'Api\Warehouse\MovementWarehouseApiController@storeEntry');
    Route::get('/entry/edit/{id}', 'Api\Warehouse\MovementWarehouseApiController@edit');
    Route::put('/entry/update/{id}', 'Api\Warehouse\MovementWarehouseApiController@update');
    Route::delete('/entry/delete/{id}', 'Api\Warehouse\MovementWarehouseApiController@destroyEntry');
    Route::get('/entry/detail/{id}', 'Api\Warehouse\MovementWarehouseApiController@detail');


    Route::get('/output/list', 'Api\Warehouse\MovementWarehouseApiController@output');
    Route::post('/output/save', 'Api\Warehouse\MovementWarehouseApiController@storeOutput');
    Route::delete('/output/delete/{id}', 'Api\Warehouse\MovementWarehouseApiController@destroyOutput');
    Route::get('/output/detail/{id}', 'Api\Warehouse\MovementWarehouseApiController@detail');


    // transfer between warehouses
    Route::get('/transfers/list', 'Api\Warehouse\MovementWarehouseApiController@transfers');
    Route::post('/transfers/save', 'Api\Warehouse\MovementWarehouseApiController@storeTransfer');


    Route::get('/stockgeneral/list', 'Api\Warehouse\MovementWarehouseApiController@stockGeneral');


    // // almacenes
    // require 'warehouse/api_warehouse.php';


    // PURCHASE MODULE ************************************

    // ======providers
    Route::get('/providers/list', 'Api\Purchase\ProviderApiController@index');
    Route::post('/providers/save', 'Api\Purchase\ProviderApiController@store');
    Route::get('/providers/edit/{id}', 'Api\Purchase\ProviderApiController@edit');
    Route::put('/providers/update/{id}', 'Api\Purchase\ProviderApiController@update');
    Route::delete('/providers/delete/{id}', 'Api\Purchase\ProviderApiController@destroy');
    Route::get('/providers/search/angucomplet', 'Api\Purchase\ProviderApiController@searchAngucomplete');


    // ======purchases
    Route::get('/purchases/list', 'Api\Purchase\PurchaseApiController@index');
    Route::post('/purchases/save', 'Api\Purchase\PurchaseApiController@store');
    Route::get('/purchases/edit/{id}', 'Api\Purchase\PurchaseApiController@edit');
    Route::put('/purchases/update/{id}', 'Api\Purchase\PurchaseApiController@update');
    Route::delete('/purchases/delete/{id}', 'Api\Purchase\PurchaseApiController@destroy');

    Route::get('/purchases/detail/{id}', 'Api\Purchase\PurchaseApiController@detail');


    // ======order purchases
    Route::get('/order/purchase/list', 'Api\Purchase\PurchaseOrderApiController@index');
    Route::get('/order/purchase/edit/{id}', 'Api\Purchase\PurchaseOrderApiController@edit');
    Route::put('/order/purchase/update/{id}', 'Api\Purchase\PurchaseOrderApiController@update');
    Route::post('/order/purchase/save', 'Api\Purchase\PurchaseOrderApiController@store');
    Route::delete('/order/purchase/delete/{id}', 'Api\Purchase\PurchaseOrderApiController@destroy');
    Route::get('/order/purchase/detail/{id}', 'Api\Purchase\PurchaseOrderApiController@detail');



    // SALE MODULE ************************************

    // ======client
    Route::get('/client/list', 'Api\Sales\ClientApiController@index');
    Route::post('/client/save', 'Api\Sales\ClientApiController@store');
    Route::get('/client/edit/{id}', 'Api\Sales\ClientApiController@edit');
    Route::put('/client/update/{id}', 'Api\Sales\ClientApiController@update');
    Route::delete('/client/delete/{id}', 'Api\Sales\ClientApiController@destroy');

    Route::get('/client/search/angucomplet', 'Api\Sales\ClientApiController@searchAngucomplete');

    // ======orders
    Route::get('/order/list', 'Api\Sales\OrderApiController@index');
    Route::get('/order/edit/{id}', 'Api\Sales\OrderApiController@edit');
    Route::put('/order/update/{id}', 'Api\Sales\OrderApiController@update');
    Route::post('/order/save', 'Api\Sales\OrderApiController@store');

    Route::delete('/order/delete/{id}', 'Api\Sales\OrderApiController@destroy');

    Route::get('/order/detail/{id}', 'Api\Sales\OrderApiController@detail');
    Route::put('/order/delivered/{id}', 'Api\Sales\OrderApiController@updateDelivered');

    // ======sales
    Route::get('/sales/list', 'Api\Sales\SalesController@index');
    Route::put('/sales/update/{id}', 'Api\Sales\SalesController@update');
    Route::post('/sales/save', 'Api\Sales\SalesController@store');
    Route::post('/sales/save/bookhotel', 'Api\Sales\SalesController@storeToBook');
    Route::delete('/sales/delete/{id}', 'Api\Sales\SalesController@destroy');
    Route::get('/sales/detail/{id}', 'Api\Sales\SalesController@detail');
    Route::get('/sales/remake/{id}', 'Api\Sales\SalesController@remakeSale');

    // ====== proformas
    Route::get('/proformas/list', 'Api\Sales\ProformaApiController@index');
    Route::get('/proformas/edit/{id}', 'Api\Sales\ProformaApiController@edit');
    Route::put('/proformas/update/{id}', 'Api\Sales\ProformaApiController@update');
    Route::post('/proformas/save', 'Api\Sales\ProformaApiController@store');
    Route::delete('/proformas/delete/{id}', 'Api\Sales\ProformaApiController@destroy');
    Route::get('/proformas/detail/{id}', 'Api\Sales\ProformaApiController@detail');


    // MONEY MODULE ************************************

    //=====movements
    Route::get('/billing/vouchers', 'Api\Billing\VoucherApiController@listVouchers');
    Route::post('/billing/cancelledvoucher', 'Api\Billing\VoucherApiController@cancelledVoucher');

    Route::post('/billing/sendvoucher', 'Api\Billing\VoucherApiController@sendVoucher');
    Route::get('/billing/print/voucher/{id}', 'Api\Billing\VoucherApiController@printVoucher');

    // ====== billing

    Route::get('/billing/notedocuments', 'Api\Billing\VoucherApiController@listNoteDocuments');
    Route::post('/billing/notedocuments/save', 'Api\Billing\VoucherApiController@saveNoteDocument');


    // // billing
    // // require 'billing/api_billing.php';

    Route::get('/money/checkbox', 'Api\Money\MoneyApiController@checkMoneyBox');

    Route::get('/money/information/opening', 'Api\Money\MoneyApiController@informationOpening');
    Route::post('/money/openbox', 'Api\Money\MoneyApiController@openbox');
    Route::post('/money/closebox', 'Api\Money\MoneyApiController@closebox');

    // routes incomes
    Route::get('/money/concept/incomes', 'Api\Money\MoneyApiController@concepIncomes');
    Route::get('/money/income/list', 'Api\Money\MoneyApiController@listIncome');
    Route::post('/money/income/save', 'Api\Money\MoneyApiController@saveIncome');
    Route::get('/money/income/edit/{id}', 'Api\Money\MoneyApiController@edit');
    Route::put('/money/income/update/{id}', 'Api\Money\MoneyApiController@updateIncome');
    Route::delete('/money/income/delete/{id}', 'Api\Money\MoneyApiController@destroyIncome');


    Route::post('/money/income/save/amortization_booking', 'Api\Money\MoneyApiController@saveAmortizationBooking');



    // routes expenses
    Route::get('/money/concept/expenses', 'Api\Money\MoneyApiController@concepExpenses');
    Route::get('/money/expense/list', 'Api\Money\MoneyApiController@listExpense');
    Route::post('/money/expense/save', 'Api\Money\MoneyApiController@saveExpense');
    Route::get('/money/expense/edit/{id}', 'Api\Money\MoneyApiController@edit');
    Route::put('/money/expense/update/{id}', 'Api\Money\MoneyApiController@updateExpense');
    Route::delete('/money/expense/delete/{id}', 'Api\Money\MoneyApiController@destroyExpense');

    // routes history moneybox
    Route::get('/money/historybox/list', 'Api\Money\MoneyApiController@listHistoryMoneyBox');

    // routes money movements
    Route::get('/money/movements/list', 'Api\Money\MoneyApiController@listMoneyMovements');

    // routes charges pending
    Route::get('/money/charge/list', 'Api\Money\MoneyApiController@listCharge');
    Route::get('/money/pendingpayments/list', 'Api\Money\MoneyApiController@listPendingPayments');
    Route::get('/money/charge/detail/{id}', 'Api\Money\MoneyApiController@detailCharge');
    Route::post('/money/charge/amortization', 'Api\Money\MoneyApiController@amotizationCharge');


    // branch offices =====================
    Route::get('/branch/branchoffices', 'Api\Branch\BranchApiController@branchOffices');

    Route::get('/branch/checkboxselected', 'Api\Branch\BranchApiController@checkBranchBoxSelected');
    Route::get('/branch/listboxes', 'Api\Branch\BranchApiController@listBoxes');
    Route::post('/branch/selectbox', 'Api\Branch\BranchApiController@selectBranchBox');

    // setting general
    Route::get('/branch/setting/general', 'Api\Branch\BranchApiController@settingGeneral');
    Route::post('/branch/setting/general/save', 'Api\Branch\BranchApiController@settingGeneralSave');


    // FINANCE MODULE ************************************

    Route::get('/finance/typeaccount', 'Api\Finance\FinanceApiController@typeAccount');

    // banks =======
    Route::get('/banks/list', 'Api\Finance\FinanceApiController@banks');
    Route::post('/banks/save', 'Api\Finance\FinanceApiController@storeBank');
    Route::get('/banks/edit/{id}', 'Api\Finance\FinanceApiController@editBank');
    Route::put('/banks/update/{id}', 'Api\Finance\FinanceApiController@updateBank');
    Route::delete('/banks/delete/{id}', 'Api\Finance\FinanceApiController@destroyBank');
    Route::get('/banks/search/all', 'Api\Finance\FinanceApiController@allBanks');

    // Account bansks =======
    Route::get('/accountbanks/list', 'Api\Finance\FinanceApiController@accountBanks');
    Route::post('/accountbanks/save', 'Api\Finance\FinanceApiController@storeAccountBank');
    Route::get('/accountbanks/edit/{id}', 'Api\Finance\FinanceApiController@editAccountBank');
    Route::put('/accountbanks/update/{id}', 'Api\Finance\FinanceApiController@updateAccountBank');
    Route::delete('/accountbanks/delete/{id}', 'Api\Finance\FinanceApiController@destroyAccountBank');
    Route::get('/accountbanks/search/all', 'Api\Finance\FinanceApiController@allAccountBank');


    Route::get('/movements/account/list', 'Api\Finance\FinanceApiController@listMovementAccountBank');


    // HOTEL MODULE ************************************

    // bookings =============
    Route::get('/bookings/list', 'Api\Hotel\BookingApiController@index');
    Route::get('/bookings/availables_bedrooms', 'Api\Hotel\BookingApiController@availableBedroomsToday');

    Route::post('/bookings/save', 'Api\Hotel\BookingApiController@store');
    Route::get('/bookings/edit/{id}', 'Api\Hotel\BookingApiController@edit');
    Route::put('/bookings/update/{id}', 'Api\Hotel\BookingApiController@update');
    Route::put('/bookings/checkin/{id}', 'Api\Hotel\BookingApiController@checkin');
    Route::put('/bookings/checkout/{id}', 'Api\Hotel\BookingApiController@checkout');

    Route::get('/bookings/detail/{id}', 'Api\Hotel\BookingApiController@detail');


    Route::put('/bookings/enable_bedroom/{id}', 'Api\Hotel\BookingApiController@enableBedroom');
    Route::put('/bookings/maintenance_bedroom/{id}', 'Api\Hotel\BookingApiController@maintenanceBedroom');
    // custom for planning data
    Route::get('/bookings/planning', 'Api\Hotel\BookingApiController@planning');
    Route::get('/bookings/bedroom/available', 'Api\Hotel\BookingApiController@checkAvailableBedroom');


    // roomtypes =======
    Route::get('/roomtypes/list', 'Api\Hotel\HotelApiController@roomtypes');
    Route::post('/roomtypes/save', 'Api\Hotel\HotelApiController@storeRoomType');
    Route::get('/roomtypes/edit/{id}', 'Api\Hotel\HotelApiController@editRoomType');
    Route::put('/roomtypes/update/{id}', 'Api\Hotel\HotelApiController@updateRoomType');
    Route::delete('/roomtypes/delete/{id}', 'Api\Hotel\HotelApiController@destroyRoomType');
    Route::get('/roomtypes/search/all', 'Api\Hotel\HotelApiController@allRoomTypes');

    // bedrooms =======
    Route::get('/bedrooms/list', 'Api\Hotel\HotelApiController@bedrooms');
    Route::post('/bedrooms/save', 'Api\Hotel\HotelApiController@storeBedroom');
    Route::get('/bedrooms/edit/{id}', 'Api\Hotel\HotelApiController@editBedroom');
    Route::put('/bedrooms/update/{id}', 'Api\Hotel\HotelApiController@updateBedroom');
    Route::delete('/bedrooms/delete/{id}', 'Api\Hotel\HotelApiController@destroyBedroom');
    Route::get('/bedrooms/search/all', 'Api\Hotel\HotelApiController@allBedrooms');

    // rates bedrooms =======
    Route::get('/rates/search/all', 'Api\Hotel\HotelApiController@allRates');

    // REPORTS MODULE ************************************

    // rcatalog ============
    Route::get('/rcatalog/product_stock', 'Api\Report\CatalogReportController@stockProduct');
    Route::get('/rcatalog/product_stock/export', 'Api\Report\CatalogReportController@stockProductExport');

    Route::get('/rcatalog/catalog_services', 'Api\Report\CatalogReportController@catalogServices');
    Route::get('/rcatalog/catalog_services/export', 'Api\Report\CatalogReportController@catalogServicesExport');

    Route::get('/rcatalog/catalog_products', 'Api\Report\CatalogReportController@catalogProducts');
    Route::get('/rcatalog/catalog_products/export', 'Api\Report\CatalogReportController@catalogProductsExport');

    Route::get('/rcatalog/catalog_categories', 'Api\Report\CatalogReportController@catalogCategories');
    Route::get('/rcatalog/catalog_categories/export', 'Api\Report\CatalogReportController@catalogCategoriesExport');

    Route::get('/rcatalog/catalog_lines', 'Api\Report\CatalogReportController@catalogLines');
    Route::get('/rcatalog/catalog_lines/export', 'Api\Report\CatalogReportController@catalogLinesExport');

    Route::get('/rcatalog/catalog_brands', 'Api\Report\CatalogReportController@catalogBrands');
    Route::get('/rcatalog/catalog_brands/export', 'Api\Report\CatalogReportController@catalogBrandsExport');

    // rsale ============
    Route::get('/rsale/history_sale_month', 'Api\Report\SaleReportController@historySaleByMonth');
    Route::get('/rsale/history_client_vip', 'Api\Report\SaleReportController@historyClientVip');
    Route::get('/rsale/history_employee_sale', 'Api\Report\SaleReportController@historyEmployeeSale');

    Route::get('/rsale/sale_clients', 'Api\Report\SaleReportController@saleClients');
    Route::get('/rsale/sale_clients/export', 'Api\Report\SaleReportController@saleClientsExport');

    Route::get('/rsale/sale_utility_product', 'Api\Report\SaleReportController@saleUtilityProduct');
    Route::get('/rsale/sale_utility_product/export', 'Api\Report\SaleReportController@saleUtilityProductExport');

    Route::get('/rsale/sale_summary_line', 'Api\Report\SaleReportController@saleSummaryLine');


    // rpurchase ============
    Route::get('/rpurchase/list_purchases', 'Api\Report\PurchaseReportController@listPurchases');
    Route::get('/rpurchase/list_purchases/export', 'Api\Report\PurchaseReportController@listPurchasesExport');


    // raccounting ============

    Route::get('/raccounting/list_vouchers', 'Api\Report\AccountingReportController@listVouchers');
    Route::get('/raccounting/list_vouchers/export', 'Api\Report\AccountingReportController@listVouchersExport');

    Route::get('/raccounting/list_vouchers_detail', 'Api\Report\AccountingReportController@listVouchersDetail');
    Route::get('/raccounting/list_vouchers_detail/export', 'Api\Report\AccountingReportController@listVouchersDetailExport');


    Route::get('/raccounting/merchandise_valuation', 'Api\Report\AccountingReportController@merchadiseValuation');
    Route::get('/raccounting/valued_kardex', 'Api\Report\AccountingReportController@valuedKardex');
    Route::get('/raccounting/sale_by_vouchers', 'Api\Report\AccountingReportController@saleByVouchers');
    Route::get('/raccounting/sale_by_vouchers/export', 'Api\Report\AccountingReportController@saleByVouchersExport');


    // rmoney ======================================================

    Route::get('/rmoney/list_expenses', 'Api\Report\MoneyReportController@listExpenses');
    Route::get('/rmoney/list_expenses/export', 'Api\Report\MoneyReportController@listExpensesExport');


    Route::get('/system/typeproduct', 'Api\SystemApiController@typeProduct');



    // // system_core
    // require 'api_system.php';

    // SEGURIDAD MODULE ************************************

    // usuarios ============
    Route::get('/user/list', 'Api\UserApiController@index');
    Route::post('/user/save', 'Api\UserApiController@store');
    Route::get('/user/edit/{id}', 'Api\UserApiController@edit');
    Route::put('/user/update/{id}', 'Api\UserApiController@update');
    Route::put('/user/updatepassword/{id}', 'Api\UserApiController@updatePassword');
    Route::delete('/user/delete/{id}', 'Api\UserApiController@destroy');

    Route::put('/user/activated/{id}', 'Api\UserApiController@updateActivated');

    Route::get('/user/list_profile', 'Api\UserApiController@userProfile');
    Route::get('/user/search/angucomplet', 'Api\UserApiController@searchAngucomplete');

    // require 'api_management.php';

    Route::get('/report/orders_general', 'Api\ReportApiController@index');

    // require 'api_report.php';

    Route::get('services/dni/{number}', 'Api\ServiceApiController@dni');
    Route::get('services/ruc/{number}', 'Api\ServiceApiController@ruc');

    // require 'api_service.php';

    Route::get('/survey/list', 'Api\InquiryApiController@index');
    Route::get('/survey/file/{id}', 'Api\InquiryApiController@file');
    Route::post('/poll/save', 'Api\InquiryApiController@savePoll');

    // require 'api_inquiry.php';
    require 'restaurant/api_restaurant.php';

});
