<?php


Route::group(['prefix' => '/admin', 'middleware' => 'auth', 'as'=>'system.'], function () {

    Route::get('/', 'SystemController@index')->name('dashboard');
    Route::get('/company', 'System\CompanyController@index')->name('company');
    Route::get('/company/new', 'System\CompanyController@create')->name('company_create');
    Route::post('/company/save', 'System\CompanyController@store')->name('company_save');


    // modules by profile
    Route::get('/modules/byprofile/{id}', 'System\ProfileController@modulesByProfile')->name('modules_byprofile');
    // modules by plan
    Route::get('/modules/byplan/{id}', 'System\PlansController@modulesByPlan')->name('modules_byplan');

    // profile
    Route::get('/profiles', 'System\ProfileController@index')->name('profiles');
    Route::get('/profiles/new', 'System\ProfileController@create')->name('profiles_create');
    Route::post('/profiles/save', 'System\ProfileController@store')->name('profiles_save');
    Route::get('/profiles/edit/{id}', 'System\ProfileController@edit')->name('profiles_edit');
    Route::post('/profiles/update/{id}', 'System\ProfileController@update')->name('profiles_update');
    Route::get('/profiles/delete/{id}', 'System\ProfileController@destroy')->name('profiles_destroy');
    Route::get('/profiles/assingmodules/{id}', 'System\ProfileController@assingModules')->name('profiles_assingmodules');
    Route::post('/profiles/assingmodules/save/{id}', 'System\ProfileController@assingModulesSave')->name('profiles_assingmodules_save');

    // assing permissions ======
    Route::get('/profiles/assingpermissions/{id}', 'System\ProfileController@assingPermissions')->name('profiles_assingpermissions');
    Route::post('/profiles/assingpermissions/save/{id}', 'System\ProfileController@assingPermissionsSave')->name('profiles_assingpermissions_save');

    // profile permissions ======
    Route::get('/modulepermissions/byprofile/{id}', 'System\ProfileController@permissionsByProfile')->name('modulepermissions_byprofile');

    // planes de empresas
    Route::get('/plans', 'System\PlansController@index')->name('plans');
    Route::get('/plans/new', 'System\PlansController@create')->name('plans_create');
    Route::post('/plans/save', 'System\PlansController@store')->name('plans_save');
    Route::get('/plans/edit/{id}', 'System\PlansController@edit')->name('plans_edit');
    Route::post('/plans/update/{id}', 'System\PlansController@update')->name('plans_update');
    Route::get('/plans/delete/{id}', 'System\PlansController@destroy')->name('plans_destroy');

    Route::get('/plans/assingmodules/{id}', 'System\PlansController@assingModules')->name('plans_assingmodules');
    Route::post('/plans/assingmodules/save/{id}', 'System\PlansController@assingModulesSave')->name('plans_assingmodules_save');

    // activaciones de empresas
    Route::get('/activations', 'System\ActivationsController@index')->name('activations');
    Route::get('/activations/new', 'System\ActivationsController@create')->name('activations_create');
    Route::post('/activations/save', 'System\ActivationsController@store')->name('activations_save');
    Route::get('/activations/edit/{id}', 'System\ActivationsController@edit')->name('activations_edit');
    Route::post('/activations/update/{id}', 'System\ActivationsController@update')->name('activations_update');
});

//Route::middleware('auth')->prefix('admin')->name('system.')->group(function() {
//
//    Route::get('/', 'SystemController@index')->name('dashboard');
//    Route::get('/company', 'System\CompanyController@index')->name('company');
//    Route::get('/company/new', 'System\CompanyController@create')->name('company_create');
//    Route::post('/company/save', 'System\CompanyController@store')->name('company_save');
//});
