<?php $__env->startSection('content'); ?>

    <div class="col-lg-12 col-md-12 col-sm-12 col-12">
        <div class="page-title-box form__head">
            <div class="row align-items-center">
                <div class="col-sm-6">
                    <h4 class="page-title form__head__title">
                        <?php if($is_create): ?>
                            <span>Registrar ciclo de activación</span>
                        <?php else: ?>
                            <span>Editar plan empresarial</span>
                        <?php endif; ?>

                    </h4>
                </div>
                <div class="col-sm-6 form__head__boxBtn">
                    <p class="m-b-0 m-t-5">Campos requeridos (<span class="required-top">*</span>)</p>
                </div>
            </div> <!-- end row -->
        </div>
    </div>

    <div class="col-lg-12">
        <div class="card m-b-30">
            <div class="card-body">

                <?php if($errors->any()): ?>
                    <div class="alert alert-danger p-10">
                        <ul class="m-0">
                            <?php $__currentLoopData = $errors->all(); $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $error): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                <li><?php echo e($error); ?></li>
                            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                        </ul>
                    </div>
                <?php endif; ?>

                <?php if($is_create): ?>
                    <form action="<?php echo e(route('system.activations_save')); ?>" method="post" class="row">
                        <?php echo csrf_field(); ?>


                        <div class="form-group col-lg-6">
                            <label>Seleccionar empresa <span class="required"></span></label>
                            <select class="form-control" name="company_id">
                                <option value="0">SELECCIONAR EMPRESA</option>
                                <?php $__currentLoopData = $companies; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $item): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                    <option value="<?php echo e($item->id); ?>"><?php echo e($item->name_complete); ?></option>
                                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                            </select>


                        </div>
                        <div class="form-group col-lg-2">
                            <label>Fecha de Inicio <span class="required"></span></label>
                            <input type="date" class="form-control text-uppercase" name="date_start" required>
                        </div>
                        <div class="form-group col-lg-2">
                            <label>Fecha de Finalización <span class="required"></span></label>
                            <input type="date" class="form-control text-uppercase" name="date_end" required>
                        </div>
                        <div class="form-group col-lg-2">
                            <label>Monto a pagar S/ <span class="required"></span></label>
                            <input type="number" class="form-control" name="amount" required>
                        </div>
                        <div class="form-group col-lg-6">
                            <label>Observación</label>
                            <input type="text" class="form-control text-uppercase" name="observation" >
                        </div>
                        <div class="form-group col-lg-12 form__footerBtn">
                            <div class="text-right">
                                <a href="<?php echo e(route('system.activations')); ?>" class="btn btn-secondary waves-effect m-l-5">
                                    Cancelar
                                </a>
                                <button type="submit" class="btn btn-primary waves-effect waves-light">
                                    Guardar
                                </button>
                            </div>
                        </div>
                    </form>
                <?php else: ?>
                        <form action="<?php echo e(route('system.activations_update',['id'=>$item->id])); ?>" method="post" class="row">
                            <?php echo csrf_field(); ?>


                            <div class="form-group col-lg-6">
                                <label>Seleccionar empresa <span class="required"></span></label>
                                <select class="form-control" name="company_id">
                                    <?php $__currentLoopData = $companies; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $company): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                        <?php if($item->company_id == $company->id): ?>
                                            <option selected="true" value="<?php echo e($company->id); ?>"><?php echo e($company->name_complete); ?></option>
                                        <?php else: ?>
                                            <option value="<?php echo e($item->id); ?>"><?php echo e($company->name_complete); ?></option>
                                        <?php endif; ?>
                                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                </select>
                            </div>
                            <div class="form-group col-lg-2">
                                <label>Fecha de Inicio <span class="required"></span></label>
                                <input type="date" class="form-control text-uppercase" name="date_start" required value="<?php echo e($item->date_start); ?>">
                            </div>
                            <div class="form-group col-lg-2">
                                <label>Fecha de Finalización <span class="required"></span></label>
                                <input type="date" class="form-control text-uppercase" name="date_end" required value="<?php echo e($item->date_end); ?>">
                            </div>
                            <div class="form-group col-lg-2">
                                <label>Monto a pagar S/ <span class="required"></span></label>
                                <input type="number" class="form-control" name="amount" required value="<?php echo e($item->amount); ?>">
                            </div>
                            <div class="form-group col-lg-6">
                                <label>Observación</label>
                                <input type="text" class="form-control text-uppercase" name="observation" value="<?php echo e($item->observation); ?>">
                            </div>
                            <div class="form-group col-lg-3">
                                <label>Estado</label>
                                <select class="form-control" name="is_active">
                                    <?php if($item->is_active == true): ?>
                                        <option selected="selected" value="true">Activado</option>
                                        <option value="false">Desactivar</option>
                                    <?php else: ?>
                                        <option selected="true" value="false">Desactivado</option>
                                        <option value="true">Activar</option>
                                    <?php endif; ?>
                                </select>
                            </div>



                            <div class="form-group col-lg-12 form__footerBtn">
                                <div class="text-right">
                                    <a href="<?php echo e(route('system.activations')); ?>" class="btn btn-secondary waves-effect m-l-5">
                                        Cancelar
                                    </a>
                                    <button type="submit" class="btn btn-primary waves-effect waves-light">
                                        Guardar cambios
                                    </button>
                                </div>
                            </div>
                        </form>
                <?php endif; ?>
            </div>
        </div>
    </div>
<?php $__env->stopSection(); ?>


<?php echo $__env->make('system.base', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /home/sisturing/public_html/resources/views/system/activation/new.blade.php ENDPATH**/ ?>