<!DOCTYPE html>
<html lang="es" ng-app="sys">

<head>
    <meta charset="utf-8"/>
    <meta http-equiv="X-UA-Compatible" content="IE=edge">
    <meta name="viewport" content="width=device-width, initial-scale=1.0, user-scalable=0, minimal-ui">
    <title><?php echo e(config('app.name')); ?> | [[title_page]]</title>
    <meta content="Tinku app" name="description"/>
    <meta content="Themesdesign" name="author"/>
    <meta name="csrf-token" content="<?php echo e(csrf_token()); ?>">

    
    <link href="<?php echo e(url('/')); ?>/stexo/assets/images/favicon.ico" rel="stylesheet">
    <link href="<?php echo e(url('/')); ?>/stexo/assets/css/bootstrap.min.css" rel="stylesheet">
    <link href="<?php echo e(url('/')); ?>/stexo/assets/css/metismenu.min.css" rel="stylesheet">
    <link href="<?php echo e(url('/')); ?>/stexo/assets/css/icons.css" rel="stylesheet">
    <link href="<?php echo e(url('/')); ?>/stexo/plugins/sweet-alert2/sweetalert2.css" rel="stylesheet">

    
    
    <link rel="stylesheet" href="<?php echo e(url('/')); ?>/js/jquery-ui/jquery-ui.css">
    <link rel="stylesheet" href="<?php echo e(url('/')); ?>/js/jquery-ui/latoja.datepicker.css">

    <link href="<?php echo e(url('/')); ?>/js/vendor/angular-notify/angular-notify.css" rel="stylesheet">

    <link href="<?php echo e(url('/')); ?>/js/select2/select2.min.css" rel="stylesheet"/>
    <link href="<?php echo e(url('/')); ?>/js/datetimepicker/bootstrap-datetimepicker.min.css" rel="stylesheet"/>

    
    <link href="<?php echo e(url('/')); ?>/js/fullcalendar/dist/fullcalendar.css" rel="stylesheet"/>
    <link href="<?php echo e(url('/')); ?>/js/fullcalendar-scheduler/scheduler.css" rel="stylesheet"/>

    <?php if($config->theme == 'white'): ?>
        <link href="<?php echo e(url('/')); ?>/stexo/assets/css/style.css" rel="stylesheet">
    <?php else: ?>
        <link href="<?php echo e(url('/')); ?>/stexo/dark/assets/css/style.css" rel="stylesheet">
    <?php endif; ?>

    
    <link href="<?php echo e(url('/')); ?>/css/vendor.min.css" rel="stylesheet">

    <!--stylus encoder -->
    <link href="<?php echo e(url('/')); ?>/design/tinku.css" rel="stylesheet">


</head>

<body class="<?php echo e($config->theme); ?>">
<!-- Begin page -->
<div id="wrapper">

    <!-- Top Bar Start -->
    <div class="topbar">

        <!-- LOGO -->
        <div class="topbar-left">
            <a href="/" class="logo">
                        <span class="logo-light">
                            <i class="mdi mdi-camera-control"></i> <?php echo e(config('app.name')); ?>

                        </span>
                <span class="logo-sm">
                            <i class="mdi mdi-camera-control"></i>
                        </span>
            </a>
        </div>

        <nav class="navbar-custom">
            <ul class="navbar-right list-inline float-right mb-0">
                <li class="dropdown notification-list list-inline-item d-none d-md-inline-block">
                    <a class="nav-link dropdown-toggle arrow-none waves-effect" data-toggle="dropdown"
                       role="button" aria-haspopup="false" aria-expanded="false">
                        <i class="fas fa-palette m-r-5"></i>Tema <span class="mdi mdi-chevron-down"></span>
                    </a>
                    <div class="dropdown-menu dropdown-menu-right dropdown-menu-animated language-switch p-b-0 p-t-0">
                        <?php if($config->theme == 'white'): ?>
                            <a class="dropdown-item active"
                               href="<?php echo e(route('tenant.sisturing_theme',['theme'=>'white'])); ?>">
                                <input type="radio" checked="checked">
                                <img src="<?php echo e(url('/')); ?>/img/white-theme.png" alt="Theme white" height="16"><span>Light theme </span>
                            </a>
                            <a class="dropdown-item" href="<?php echo e(route('tenant.sisturing_theme',['theme'=>'dark'])); ?>">
                                <input type="radio">
                                <img src="<?php echo e(url('/')); ?>/img/dark-theme.png" alt="Theme dark"
                                     height="16"><span>Dark theme </span>
                            </a>
                        <?php else: ?>
                            <a class="dropdown-item" href="<?php echo e(route('tenant.sisturing_theme',['theme'=>'white'])); ?>">
                                <input type="radio">
                                <img src="<?php echo e(url('/')); ?>/img/white-theme.png" alt="Theme white" height="16"><span>Light theme </span>
                            </a>
                            <a class="dropdown-item active"
                               href="<?php echo e(route('tenant.sisturing_theme',['theme'=>'dark'])); ?>">
                                <input type="radio" checked="checked">
                                <img src="<?php echo e(url('/')); ?>/img/dark-theme.png" alt="Theme dark"
                                     height="16"><span>Dark theme </span>
                            </a>
                        <?php endif; ?>
                    </div>
                </li>
                <li class="dropdown notification-list list-inline-item">
                    <div class="dropdown notification-list nav-pro-img">
                        <a class="dropdown-toggle nav-link arrow-none nav-user pointer" data-toggle="dropdown"
                           role="button" aria-haspopup="false" aria-expanded="false">
                            <span class="m-r-10 f-s-12 bold"><?php echo e(\Auth::user()->username); ?></span><img
                                    src="<?php echo e(url('/')); ?>/img/user_default.png" alt="user" class="rounded-circle">
                        </a>
                        <div class="dropdown-menu dropdown-menu-right profile-dropdown" ng-controller="MyAccountCtrl">
                            <!-- item-->
                            <a class="dropdown-item pointer m-b-5" ng-click="checkMyAccount('<?php echo e(\Auth::user()->id); ?>')"><i
                                        class="fas fa-user-tie"></i> Mi cuenta</a>
                            <a class="dropdown-item" href="empresa/sucursales"><i class="fas fa-home"></i>Sucursales</a>
                            <div class="dropdown-divider"></div>
                            <a class="dropdown-item text-danger" href="/logout"><i
                                        class="mdi mdi-power text-danger"></i>
                                Cerrar Sesión
                            </a>
                        </div>
                    </div>
                </li>

            </ul>

            <ul class="list-inline menu-left mb-0">
                <li class="float-left">
                    <button class="button-menu-mobile open-left waves-effect">
                        <i class="mdi mdi-menu"></i>
                    </button>
                </li>
                <li class="d-none d-md-inline-block p-t-14">
                    <div class="home__sucursalicon">
                        <i class="fas fa-home"></i>
                    </div>
                    <div class="d-inline-flex f-s-11">
                        <span class="bold">Sucursal, </span><span class="m-l-2"><?php echo e($branchoffice->description); ?></span>



                    </div>
                </li>
            </ul>

        </nav>

    </div>
    <!-- Top Bar End -->

    <!-- ========== Left Sidebar Start ========== -->
    <div class="left side-menu">
        <div class="slimscroll-menu" id="remove-scroll">

            <!--- Sidemenu -->
            <div id="sidebar-menu">
                <!-- Left Menu Start -->
                <ul class="metismenu" id="side-menu">
                    
                    
                    
                    <li class="menu-title">Menu</li>

                    <?php $__currentLoopData = $modules; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $item): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>

                        <?php if($item->ui_sref=='#'): ?>
                            <li id="<?php echo e($item->father_url); ?>">
                                <a href="javascript:void(0);" class="waves-effect <?php echo e($item->father_url); ?>"
                                   aria-expanded="false">
                                    <i class="<?php echo e($item->icon); ?>"></i>
                                    <span><?php echo e($item->name); ?><span class="float-right menu-arrow"><i
                                                    class="mdi mdi-chevron-right"></i></span></span>
                                </a>
                                <ul class="submenu mm-collapse parent_<?php echo e($item->father_url); ?>">
                                    <?php $__currentLoopData = $item->childs; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $child): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                        <li id="<?php echo e($child->module); ?>">
                                            <a ui-sref="<?php echo e($child->ui_sref); ?>" ui-sref-opts="{reload: true}"
                                               ui-sref-active="active"><?php echo e($child->name); ?></a>
                                        </li>
                                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                </ul>
                            </li>
                        <?php else: ?>
                            <li>
                                <a ui-sref="<?php echo e($item->ui_sref); ?>" ui-sref-opts="{reload: true}" ui-sref-active="active"
                                   class="waves-effect"><i class="<?php echo e($item->icon); ?>"></i><span><?php echo e($item->name); ?></span>
                                </a>
                            </li>
                        <?php endif; ?>
                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>

                </ul>

            </div>
            <!-- Sidebar -->
            <div class="clearfix"></div>

        </div>
        <!-- Sidebar -left -->

    </div>
    <!-- Left Sidebar End -->

    <!-- ============================================================== -->
    <!-- Start right Content here -->
    <!-- ============================================================== -->
    <div class="content-page">
        <!-- Start content -->
        <!--
                  <div class="loading" ng-show="show_loading">
                      <div class="bs-spinner">
                          <div class="spinner-grow text-primary" role="status">
                              <span class="sr-only">Loading...</span>
                          </div>
                      </div>
                  </div>


                          <div class="loading" id="loading_object">
                              <div class="bs-spinner">
                                  <div class="spinner-grow text-primary" role="status">
                                      <span class="sr-only">Loading...</span>
                                  </div>
                              </div>
                          </div>
                          -->

        <!--  DESIGN LOADING 2 -->
        <div class="loading content_loading" ng-show="show_loading">
            <div class="spinner" role="status">
                <div class="inner one"></div>
                <div class="inner two"></div>
                <div class="inner three"></div>
            </div>
            <p id="text">Cargando...</p>
        </div>

        <div class="loading content_loading" id="loading_object">
            <div class="spinner" role="status">
                <div class="inner one"></div>
                <div class="inner two"></div>
                <div class="inner three"></div>
            </div>
            <p id="text">Cargando...</p>
        </div>


        <div class="content position-relative">
            <div class="container-fluid p-0">
                <div class="content__body">
                    <div ui-view></div>
                </div>
            </div>
            <!-- container-fluid -->

        </div>
        <!-- content -->

        
        
        

    </div>

</div>


<script src="<?php echo e(url('/')); ?>/js/jquery/jquery-3.5.1.min.js"></script>
<script src="<?php echo e(url('/')); ?>/js/jquery-ui/jquery-ui-12.js"></script>

<script src="<?php echo e(url('/')); ?>/js/vendor.min.js"></script>
<script src="<?php echo e(url('/')); ?>/js/vendor/angular-notify/angular-notify.js"></script>


<script src="<?php echo e(url('/')); ?>/js/jsbarcode/jquery-barcode.js"></script>
<script src="<?php echo e(url('/')); ?>/js/datetimepicker/bootstrap-datetimepicker.min.js"></script>



<script>
    jQuery.browser = {};
    (function () {
        jQuery.browser.msie = false;
        jQuery.browser.version = 0;
        if (navigator.userAgent.match(/MSIE ([0-9]+)\./)) {
            jQuery.browser.msie = true;
            jQuery.browser.version = RegExp.$1;
        }
    })();
</script>

<script src="<?php echo e(url('/')); ?>/js/number-to-letter.js"></script>


<script src="<?php echo e(url('/')); ?>/js/select2/select2.min.js"></script>


<script src="<?php echo e(url('/')); ?>/js/highchartgraph/highcharts.js"></script>
<script src="<?php echo e(url('/')); ?>/js/highchartgraph/highcharts-more.js"></script>
<script src="<?php echo e(url('/')); ?>/js/highchartgraph/exporting.js"></script>


<script src="<?php echo e(url('/')); ?>/js/fullcalendar/dist/fullcalendar.js"></script>
<script src="<?php echo e(url('/')); ?>/js/fullcalendar-scheduler/scheduler.js"></script>
<script src="<?php echo e(url('/')); ?>/js/fullcalendar-scheduler/locale-all.js"></script>






<script src="<?php echo e(url('/')); ?>/js/encoder.min.js"></script>

</body>
</html>
<?php /**PATH /home/sisturing/public_html/resources/views/base/base_admin.blade.php ENDPATH**/ ?>