<?php $__env->startSection('content'); ?>
    <div class="row">
        <div class="col-lg-12 col-md-12 col-sm-12 col-12">
            <div class="page-title-box">
                <div class="row align-items-center">
                    <div class="col-sm-6 col-md-6 col-sm-6 col-12">
                        <h4 class="page-title content__title">Activaciones de empresas</h4>
                    </div>
                    <div class="col-sm-6 col-sm-6 col-md-6 col-sm-6 col-12 text-right">
                        <a href="<?php echo e(route('system.activations_create')); ?>" class="btn btn-primary waves-effect waves-light">
                            <i class="fa fa-plus m-r-5"></i> Crear activación
                        </a>
                    </div>
                </div> <!-- end row -->
            </div>
        </div>
        <div class="col-lg-12 col-lg-12 col-md-12 col-sm-12 col-12">
            <div class="card m-b-30">
                <div class="card-body">
                    <div class="table-responsive">
                        <table class="table table-hover">
                            <thead>
                            <tr>
                                <th scope="col">RUC</th>
                                <th scope="col">RAZON SOCIAL</th>
                                <th class="text-center">Fecha Inicio</th>
                                <th class="text-center">Fecha Finalización</th>
                                <th>Estado</th>
                                <th></th>
                            </tr>
                            </thead>
                            <tbody>
                            <?php if(count($items)==0): ?>
                                <tr class="text-center">
                                    <td colspan="3">No se encontraron registros</td>
                                </tr>
                            <?php else: ?>
                                <?php $__currentLoopData = $items; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $item): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                    <tr>
                                        <td><?php echo e($item->company_data->ruc); ?></td>
                                        <td><?php echo e($item->company_data->social_reason); ?></td>
                                        <td class="text-center"><?php echo e($item->date_start); ?></td>
                                        <td class="text-center"><?php echo e($item->date_end); ?></td>
                                        <td>
                                            <?php if($item->is_active): ?>
                                                <span class="badge badge-success f-s-12">Activo</span>
                                            <?php else: ?>
                                                <span class="badge badge-warning f-s-12">Desactivado</span>
                                            <?php endif; ?>
                                        </td>
                                        <td class="text-center">
                                            <a href="<?php echo e(route('system.activations_edit',['id'=>$item->id])); ?>" title="Editar"
                                               class="btn btn-sm btn-primary"><i class="fas fa-pen-alt"></i></a>



                                        </td>
                                    </tr>
                                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                            <?php endif; ?>
                            </tbody>
                        </table>
                    </div>

                </div>
            </div>
        </div>
    </div>
<?php $__env->stopSection(); ?>

<?php echo $__env->make('system.base', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /home/sisturing/public_html/resources/views/system/activations.blade.php ENDPATH**/ ?>